// suspenddata.js
//
// Dependencies: unitech.js
//
// This file acts as an interface for the individual
// pages of the courseware to interact with the
// suspendData VarStore object that resides in the
// toolbar frame.
//
// Developers should not interact with suspendData object
// directly, instead they should use the interface
// functions provided in this file to set/get/remove
// name, value pairs.
//
// Developers can save a limited amount of data to
// suspendData (4096 BYTES), some of which is going
// to be used by the framework already.  So it is 
// suggested that data stored here be minimal.  This 
// means that both variable names and values should 
// be in their smallest possible form.
//
// Usage: 
// Developers should restrict their usage of
// the suspendData object to setting variables,
// getting variable values, and removing variables
// that they themselves have created.
//
//    setVar("bt1","t");
// Sets the variable named "bt1" equal to "t".
//
//    getVar("bt1");
// Returns the string "t" that was previously set.
//
//    removeVar("bt1");
// Removes the variable "bt1" from the storage
// object.
//
// The suspendData object is also used by the framework
// code to manage BeenThere values for topic and page
// BeenTheres, as well as scores for PE questions
// and bookmarking info.

// Sets a persistent variable's value. 
function setVar(tok,val)
{
	return toolbarAPI.setVar(tok,val);
}

// Gets a persistent variable's value. 
function getVar(tok)
{
	return toolbarAPI.getVar(tok);
}

// Removes a persistent variable. 
function removeVar(tok)
{
	return toolbarAPI.setVar(tok,null);
}

